:

# Check that r2sync synchronizes two targets that are files.

trap 'rm -f $TMP1 $TMP2' 0
TMP1=`mktemp /tmp/test-XXXXXX` || exit 1
TMP2=`mktemp /tmp/test-XXXXXX` || exit 1

set -v

# Create two files. Let r2sync sync them. As both are new, the "-c
# '>'" causes TMP1 to override TMP2.
#
echo "This is a text." >$TMP1
echo "This is also a text." >$TMP2
./r2sync -b -c '>' $TMP1 $TMP2 || exit 1

# Check that the files are the same now.
#
diff -u $TMP1 $TMP2 || exit 1

# Change one of the files and sync again.
#
echo "Additional line." >>$TMP1
./r2sync -b $TMP1 $TMP2 || exit 1

# Check that the files are the same again.
#
diff -u $TMP1 $TMP2 || exit 1

# Remove the log files.
#
./r2sync -b -r $TMP1 $TMP2 || exit 1
