:

# Test if r2sync is able to update a file from a local file that
# already has the desired contents.

trap 'rm -rf $TMPDIR' 0
TMPDIR=`mktemp -d /tmp/test-XXXXXX` || exit 1

# Make two files with different contents
#
echo "1111111111" >$TMPDIR/relatively-long-file-name-1
echo "2222222222" >$TMPDIR/relatively-long-file-name-2

# Start r2sync and tell it to update file1. We actually pass incorrect
# checksums, but the server won't verify them. The delta ("*1") simply
# copies the existing contents of file1. Then tell the server to
# update file2 to the same size and checksums. It should do so by
# copying file1 and without needing any delta. (The line "? 301 No
# delta" is there in case the server *does* ask for a delta.)
#
./r2sync -d <<EOF
local $TMPDIR
remote foo
update 800 644 1521286422 11 aaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa relatively-long-file-name-1
*1
.
update 800 644 1521286422 11 aaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa relatively-long-file-name-2
? 301 No delta
reset
quit
EOF

# Check that file1 is now the same as file2, even though we didn't
# send any delta.
#
diff -u $TMPDIR/relatively-long-file-name-2 $TMPDIR/relatively-long-file-name-1
