:

# Test option -i

set -v

# Make two directories and put some files in one of them.
#
trap 'rm -rf $TMPDIR1 $TMPDIR2' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1

echo "This is file 1" >$TMPDIR1/file1
echo "This is file 2" >$TMPDIR1/file2
echo "This is file 3" >$TMPDIR1/file3

# Let r2sync copy the files to TMPDIR2
#
./r2sync -b -c '>' $TMPDIR1 $TMPDIR2 || exit 1

# Check that the files have been copied
#
cmp $TMPDIR1/file1 $TMPDIR2/file1 || exit 1
cmp $TMPDIR1/file2 $TMPDIR2/file2 || exit 1
cmp $TMPDIR1/file3 $TMPDIR2/file3 || exit 1

# Modify all files in TMPDIR1
#
echo "This is a modified file 1" >$TMPDIR1/file1
echo "This is a modified file 2" >$TMPDIR1/file2
echo "This is a modified file 3" >$TMPDIR1/file3

# Let r2sync synchronize the directories, but only files that end in "1" or "3"
#
./r2sync -b -e '*' -i '*1' -i '*3' $TMPDIR1 $TMPDIR2 || exit 1

# Check that the files have been synchronised, except for file2.
#
cmp $TMPDIR1/file1 $TMPDIR2/file1 || exit 1
cmp $TMPDIR1/file2 $TMPDIR2/file2 && exit 1
cmp $TMPDIR1/file3 $TMPDIR2/file3 || exit 1

# Remove the log of the synchronisation.
#
./r2sync -b -r $TMPDIR1 $TMPDIR2 || exit 1
