:

# Test if r2sync in daemon mode correctly updates a file.

trap 'rm -rf $TMPDIR' 0
TMPDIR=`mktemp -d /tmp/test-XXXXXX` || exit 1

echo "The quick brown fox jumps over the lazy dog" | tr -d '\n' >$TMPDIR/test
echo "The quick brown fox jumps over the lazy dog." | tr -d '\n' >$TMPDIR/expect

cat >$TMPDIR/expected <<EOF
ready 1
OK
OK
directory
5ba20fd9 9e107d9d372bb6826bd81d3542a419d6 2b
.
OK
OK
EOF

# The input for the rsync daemon sets the protocol version to 1, an
# arbitrary remote, the temporary directory as local target, asks for
# the signatures of the test1 file we created above and then sends a
# delta that refers to the old content of the file, followed by a "."
# (Lg== in base64).
./r2sync -d >$TMPDIR/output <<EOF
version 1
remote a
local $TMPDIR
update 700 644 0 0 0 00000000000000000000000000000000 test
*1
Lg==
.
reset
quit
EOF

diff -u $TMPDIR/expect $TMPDIR/test
