typedef struct hashtable *hashtable;
typedef unsigned long (*hashfunction)(const void*, size_t);
typedef 
              _Bool 
                   (*hashcompare)(const void*, size_t, const void*, size_t);
typedef struct hashcursor *hashcursor;
extern hashtable hash_create(hashfunction fn, hashcompare eq);
extern void hash_destroy(hashtable table);
extern void *hash_get(hashtable const table, const void * const key,
        const size_t keylen, size_t *datalen);
extern void *hash_nget(hashtable const table, const void * const key,
         const size_t keylen, int n, size_t *datalen);
extern _Bool 
           hash_put(hashtable const table,
       void* const key, const size_t klen,
       void* const data, const size_t dlen);
extern _Bool 
           hash_add(hashtable const table,
       void* const key, const size_t klen,
       void* const data, const size_t dlen);
extern void hash_del(hashtable const table, const void * const key,
       const size_t keylen);
extern hashcursor hash_cursor(hashtable table);
extern void *hash_next(hashcursor cursor, size_t *keylen);
