/*
  Error messages between the client and the server have the form

     ? CODE TEXT

  where "?" is a question mark in the first position of the line, CODE
  is a decimal number and TEXT is a short explanation. TEXT is in
  English, but in principle every kind of error has a unique code and
  thus CODE can be used to localize the error

  Codes 300-299 are sent by the client to the server to inform it of
  an error, e.g., when the client is sending signature data after a
  "delta" command but is unable to continue.

  Codes 400-499 are codes reported by the server when it considers an
  error was made by the client. Codes 500 and higher are reported by
  the server when something went wrong on the server side: out of
  memory, could not create temporary file, could not fork, etc.

  Codes 501 and higher correspond to system errors + 500. See, e.g,
  the manual page strerror(3) for how to translate error codes to
  text.
*/

#include "stdincls.h"

EXPORT enum error_code {
  EC_SHORTCUT = 200,	   /* Update could be handled locally */
  EC_NOSIG = 300,	   /* Not enough data to compute a delta */
  EC_NODELTA,		   /* Not enough data to patch a file */
  EC_SYNTAX = 400,	   /* Syntax error */
  EC_REMOTE,		   /* Command "remote" was not yet given */
  EC_LOCAL,		   /* Command "local" was not yet given */
  EC_BLOCKSIZE,		   /* Missing or incorrect block size */
  EC_COMMAND,		   /* Unknown command */
  EC_VERSION,		   /* Unknown protocol version */
  EC_MODE,		   /* Illegal value for file mode bits */
  EC_TIME,		   /* Missing time value */
  EC_TOOLONG,		   /* Path is longer than FILENAME_MAX */
  EC_NOLOG,		   /* No log available because of an earlier error */
  EC_CHMOD,		   /* Can only set mode of a regular file */
  EC_INVDELTA,		   /* Invalid syntax for delta */
  EC_NOSYSTEMID,	   /* Failed to get a unique system ID */
  EC_SERVER = 500,	   /* Server error (base for system errors) */
};
